<?php
require_once __DIR__ . '/../config/database.php';

try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_PERSISTENT => true,
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
        ]
    );

    // Check if permissions already exist
    $existingPermissions = ['add_user', 'edit_user', 'delete_user', 'edit_role', 'delete_role'];
    
    foreach ($existingPermissions as $permission) {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM permissions WHERE name = ?");
        $stmt->execute([$permission]);
        $exists = $stmt->fetchColumn() > 0;
        
        if (!$exists) {
            // Add the permission
            $stmt = $pdo->prepare("INSERT INTO permissions (name, description) VALUES (?, ?)");
            
            switch ($permission) {
                case 'add_user':
                    $stmt->execute([$permission, 'Add new users']);
                    break;
                case 'edit_user':
                    $stmt->execute([$permission, 'Edit user information']);
                    break;
                case 'delete_user':
                    $stmt->execute([$permission, 'Delete users']);
                    break;
                case 'edit_role':
                    $stmt->execute([$permission, 'Edit role information']);
                    break;
                case 'delete_role':
                    $stmt->execute([$permission, 'Delete roles']);
                    break;
            }
            
            echo "Added permission: $permission\n";
        } else {
            echo "Permission already exists: $permission\n";
        }
    }
    
    echo "Migration completed successfully!\n";
    
} catch (PDOException $e) {
    echo "Migration failed: " . $e->getMessage() . "\n";
}
?> 